static int _lastParticleId = 0; //<>//

public class Particle
{
  int _id;            // Unique id for each particle

  PVector _s;         // Position (m)
  PVector _v;         // Velocity (m/s)
  PVector _a;         // Acceleration (m/(s*s))
  PVector _F;         // Force (N)
  float _m;           // Mass (kg)

  PVector _n;

  boolean _gravity;   // If true, the particle will be affected by gravity
  boolean _clamped;   // If true, the particle will not move

  boolean _hasDamping = false;
  boolean _collide = true;


  Particle(PVector s, PVector v, float m, boolean gravity, boolean clamped)
  {
    _id = _lastParticleId++;

    _s = s.copy();
    _v = v.copy();
    _m = m;

    _gravity = gravity;
    _clamped = clamped;

    this._n = new PVector();

    _a = new PVector(0.0, 0.0, 0.0);
    _F = new PVector(0.0, 0.0, 0.0);
  }

  Particle(PVector s, PVector v, float m, boolean gravity, boolean clamped, boolean damping, boolean collide)
  {
    _id = _lastParticleId++;

    _s = s.copy();
    _v = v.copy();
    _m = m;

    _gravity = gravity;
    _clamped = clamped;
    _hasDamping = damping;
    _collide = collide;
    this._n = new PVector();

    _a = new PVector(0.0, 0.0, 0.0);
    _F = new PVector(0.0, 0.0, 0.0);
  }

  void update(float simStep)
  {
    if (_clamped)
      return;

    if (_gravity)
      updateWeightForce();

    if( windEnabled)
      updateWindForce();

    
      
    // Simplectic Euler:
    // v(t+h) = v(t) + h*a(s(t),v(t))
    // s(t+h) = s(t) + h*v(t+h)

    _a.set( PVector.div( _F, _m));
    _v.add( PVector.mult( _a, simStep));
    if( this._hasDamping){
      _v.sub( PVector.mult( _v, 0.005));
    }
    _s.add( PVector.mult( _v, simStep));
    // _s.add( _v);
    _F.set( 0.0, 0.0, 0.0);
  }

  int getId()
  {
    return _id;
  }

  void addPos( PVector pos){
    this._s.add( pos);
  }

  void toggleGravity(){
    this._gravity = !this._gravity;
  }

  void setGravity( boolean gravity){
    this._gravity = gravity;
  }

  void toggleClamped(){
    this._clamped = !this._clamped;
  }

  PVector getPos()
  {
    return _s;
  }

  void setPos(PVector s)
  {
    this._s = s.copy();
    _a.set(0.0, 0.0, 0.0);
    _F.set(0.0, 0.0, 0.0);
  }

  PVector getVel(){
    return this._v.copy();
  }

  void setVel(PVector v)
  {
    _v = v.copy();
  }

  void addVel( PVector v){
    this._v.add( v);
  }

  void setNormal( PVector normal){
    this._n.set( normal).normalize();
  }

  void updateWeightForce()
  {
    PVector weigthForce = new PVector(0, 0, -G*this._m);
    _F.add(weigthForce);
  }

  void updateWindForce(){

    PVector windForce = new PVector();
    windForce.set( PVector.mult( Fwind, Fwind.dot( this._n)).mult( fwind));
    addExternalForce( windForce);
  }

  void addExternalForce(PVector F)
  {
    if( _collide)
      _F.add(F);
  }
}
