// Definitions:

// Spring Layout
enum SpringLayout
{
  STRUCTURAL,
  SHEAR,
  BEND,
  STRUCTURAL_AND_SHEAR,
  STRUCTURAL_AND_BEND,
  SHEAR_AND_BEND,
  STRUCTURAL_AND_SHEAR_AND_BEND
}

enum layoutType
{
  STRUCTURAL,
  SHEAR,
  BEND
}

// SpringLayout _springLayout = SpringLayout.STRUCTURAL;

// Simulation values:

final boolean REAL_TIME = true;   // To make the simulation run in real-time or not
final float TIME_ACCEL = 1.0;     // To simulate faster (or slower) than real-time


// Display and output parameters:

boolean DRAW_MODE = false;                            // True for wireframe
final int DRAW_FREQ = 100;                            // Draw frequency (Hz or Frame-per-second)
final int DISPLAY_SIZE_X = 1000;                      // Display width (pixels)
final int DISPLAY_SIZE_Y = 1000;                      // Display height (pixels)
final float FOV = 60;                                 // Field of view (º)
final float NEAR = 0.01;                              // Camera near distance (m)
final float FAR = 10000.0;                            // Camera far distance (m)
final color OBJ_COLOR = color(250, 240, 190);         // Object color (RGB)
final color BALL_COLOR = color(225, 127, 80);         // Ball color (RGB)
final color BACKGROUND_COLOR = color(190, 1800, 210); // Background color (RGB)
final int [] TEXT_COLOR = {0, 0, 0};                  // Text color (RGB)
final String FILE_NAME = "2.SHEAR_AND_BEND.csv";                  // File to write the simulation variables

// Parameters of the problem:

final float TS = 0.001;     // Initial simulation time step (s)
final float G = 981;       // Acceleration due to gravity (m/(s·s))

final int N_H = 50;         // Number of nodes of the object in the horizontal direction
final int N_V = 50;         // Number of nodes of the object in the vertical direction

final float D_H = 40.0;     // Separation of the object's nodes in the local horizontal direction (m)
final float D_V = 20.0;     // Separation of the object's nodes in the local vertical direction (m)

final float P_M = 0.01;      // Particle mass (Kg)
final float B_M = 1.0;     // Ball mass (Kg)
final float B_R = 30.0;     // Ball Radius (cm)

final float Ke = 3000;
final float Kd = 0.5;

final float MAX_FORCE = 25000;

final float iniTimedisplacement = 10;
final PVector displacement = new PVector( 10, 0, 0);


// Banderas time
final float sepH = 5;
final float sepV = 5;
final int nodesH = 60;
final int nodesV = 30;

//...
//...
//...
