public class Ball extends Particle
{
  float _r;       // Radius (m)
  color _color;   // Color (RGB)


  Ball(PVector s, PVector v, float m, float r, boolean gravity, color c)
  {
    super(s, v, m, gravity, true);

    _r = r;
    _color = c;
  }

  Ball(PVector s, PVector v, float m, float r, boolean gravity, color c, boolean damping, boolean collide)
  {
    super(s, v, m, gravity, false, damping, collide);

    _r = r;
    _color = c;
  }

  Ball(PVector s, PVector v, float m, float r, boolean gravity, boolean clamped, color c)
  {
    super(s, v, m, gravity, clamped);

    _r = r;
    _color = c;
  }
  

  float getRadius()
  {
    return _r;
  }

  void computeColisionSpringFloor(){
    if( this.getPos().z < B_R){
      float lRep = B_R;
      float dist = this.getPos().z;
      PVector distu = new PVector( 0, 0, 1);

      float Fs = -100 * ( dist - lRep);
      PVector Fs1 = PVector.mult( distu, Fs);
      _ball.addExternalForce( Fs1);
    }
  }

  // void addExternalForce( PVector F, boolean active){
  //   if( this.active)
  //     super.addExternalForce( F);
  // }

  void render()
  {
    pushMatrix();
    {
      translate(_s.x, _s.y, _s.z);
      fill(_color);
      stroke(0);
      strokeWeight(0.5);
      sphereDetail(25);
      sphere(_r);
    }
    popMatrix();
  }
}
