///////////////////////////////////////////////////////////////////////
//
// WAVE
//
///////////////////////////////////////////////////////////////////////

abstract class Wave
{
  
  protected PVector tmp;
  
  protected float A,C,W,Q,phi; // A- Amplitude, C- speed, W- WaveLength, Q- FreQuency, phi- fase
  protected PVector D;//Direction or centre
  
  public Wave(float _a,PVector _srcDir, float _L, float _C)
  {
    this.A = _a;
    this.D = _srcDir;
    this.C = _C;
    this.W = _L;
    this.Q = 2*PI/_L;
    this.phi = _C * this.Q;
  }
  
  abstract PVector getVariation(float x, float y, float z, float time);
}

///////////////////////////////////////////////////////////////////////
//
// DIRECTIONAL WAVE
//
///////////////////////////////////////////////////////////////////////

class WaveDirectional extends Wave
{
  public WaveDirectional(float _a,PVector _srcDir, float _L, float _C)
  {
    super(_a, _srcDir, _L, _C);
  }
  
  public PVector getVariation(float x, float y, float z, float time)
  {
    if( print){
      println( "x: " + x + ", y: " + y + ", z: "+ z);
      print = false;
    }
    PVector point = new PVector( x, y, z);
    return new PVector( 1, this.A * sin( this.Q * PVector.dot( this.D.normalize( null), point) + this.phi*time), 1);
  }
}

///////////////////////////////////////////////////////////////////////
//
// RADIAL WAVE
//
///////////////////////////////////////////////////////////////////////

class WaveRadial extends Wave
{
  public WaveRadial(float _a,PVector _srcDir, float _L, float _C)
  {
    super(_a, _srcDir, _L, _C);
  }
  
  public PVector getVariation(float x, float y, float z, float time)
  {
    // return ...;
    PVector point = new PVector( x, y, z);

    return new PVector( 1, this.A * sin( this.Q * this.D.dist( point) - this.phi*time), 1);
  }
}



///////////////////////////////////////////////////////////////////////
//
// GERSTNER WAVE
//
///////////////////////////////////////////////////////////////////////

class WaveGerstner extends Wave
{
  public WaveGerstner(float _a,PVector _srcDir, float _L, float _C)
  {
    super(_a, _srcDir, _L, _C);
 
  }
  
  public PVector getVariation(float x, float y, float z, float time)
  {
    // return ...;
    PVector point = new PVector( x, y, z);
    x = this.A * this.D.x *cos( this.Q * PVector.dot( this.D, point) + this.phi*time);
    z = this.A * this.D.z *cos( this.Q * PVector.dot( this.D, point) + this.phi*time);
    return new PVector( x, this.A * sin( this.Q*PVector.dot( this.D, point) + this.phi*time), z);
  }
}
