static int _lastParticleId = 0; //<>//

public class Particle
{
  int _id;            // Unique id for each particle

  PVector _s;         // Position (m)
  PVector _v;
  PVector _a;         // Acceleration (m/(s*s))
  PVector _F;         // Force (N)
  float _m;           // Mass (kg)
  float _radius;
  boolean _gravity;
  boolean _madeWave;
  color _c;

  Particle(PVector s, PVector v, float m, float radius, boolean gravity)
  {
    _id = _lastParticleId++;

    this._s = s.copy();
    this._v = v.copy();
    this._m = m;
    this._radius = radius;

    this._c = #ff0000;

    _gravity = gravity;
    this._madeWave = false;

    _a = new PVector(0.0, 0.0, 0.0);
    _F = new PVector(0.0, 0.0, 0.0);
  }

  void update(float simStep)
  {
    if( this._gravity)
      updateWeightForce();

    // Simplectic Euler:
    // v(t+h) = v(t) + h*a(s(t),v(t))
    // s(t+h) = s(t) + h*v(t+h)

    _a.set( PVector.div( _F, _m));
    _v.add( PVector.mult( _a, simStep));
    _s.add( PVector.mult( _v, simStep));
    _F.set( 0.0, 0.0, 0.0);
  }

  float getRadius(){
    return this._radius;
  }

  int getId()
  {
    return _id;
  }

  void toggleGravity(){
    this._gravity = !this._gravity;
  }

  PVector getPos()
  {
    return _s.copy();
  }

  void setPos(PVector s)
  {
    this._s = s.copy();
    _a.set(0.0, 0.0, 0.0);
    _F.set(0.0, 0.0, 0.0);
  }

  PVector getVel(){
    return this._v;
  }

  void setVel(PVector v)
  {
    _v = v.copy();
  }

  void updateWeightForce()
  {
    PVector weigthForce = new PVector(0, G*this._m, 0);
    PVector windForce = new PVector( 100, 0, -100);

    _F.add(weigthForce);
    _F.add(windForce);
  }

  void addExternalForce(PVector F)
  {
    _F.add(F);
  }

  void display(){
    pushMatrix();
    {
      translate(_s.x, _s.y, _s.z);
      fill( _c);
      stroke(0);
      strokeWeight(0.5);
      sphereDetail(25);
      sphere(_radius);
    }
    popMatrix();
  }
}
