import peasy.*;

final int _MAP_SIZE = 150;
final float _MAP_CELL_SIZE = 10f;

final float G = 9.81;

boolean _viewmode = false;
boolean _clear = false;

boolean print = true;

PeasyCam camera;

HeightMap map;
PImage img;
Particle[][] waterParticles;
ArrayList<Particle> particles;
float prev_time = 0;
float current_time = 0;

public void settings() {
    System.setProperty("jogl.disable.openglcore", "true");
    //size(900,600, P3D);
    fullScreen(P3D);
  }
void setup()
{
  //size(1024,768,P3D);
  //fullScreen(P3D);
  img = loadImage("water_surface.jpg");
  camera = new PeasyCam(this,100);
  camera.setMinimumDistance(50);
  camera.setMaximumDistance(2500);
  camera.setDistance(400);
  map = new HeightMap(_MAP_SIZE, _MAP_CELL_SIZE);

  waterParticles = new Particle[_MAP_SIZE][_MAP_SIZE];
  particles = new ArrayList<Particle>();
  PVector pos = new PVector();
  PVector vel = new PVector();
  for( int i = 0; i < _MAP_SIZE; i++){
    for( int j = 0; j < _MAP_SIZE; j++){
      pos.set( map.pos[i][j][0], map.pos[i][j][1], map.pos[i][j][2]);
      waterParticles[i][j] = new Particle( pos, vel, 1, 0.1, false);
    }
  }
}

void updateWaterParticles(){
  PVector pos = new PVector();
  for( int i = 0; i < _MAP_SIZE; i++){
    for( int j = 0; j < _MAP_SIZE; j++){
      pos.set( map.pos[i][j][0], map.pos[i][j][1], map.pos[i][j][2]);
      waterParticles[i][j].setPos( pos);
    }
  }
}

void updateParticles( float timeStep){
  for( Particle p : particles){
    p.update( timeStep);
  }
}

void computeCollisions(){
  PVector dist = new PVector();
  PVector Fs = new PVector();
  float ke = 0.6;
  float lRep;
  float fs;

  for( Particle p : particles){
    for( int i = 0; i < _MAP_SIZE; i++){
      for( int j = 0; j < _MAP_SIZE; j++){
        dist.set( PVector.sub( p.getPos(), waterParticles[i][j].getPos()));
        lRep = p.getRadius() + waterParticles[i][j].getRadius();
        if( dist.mag() < lRep){
          fs = -ke * ( dist.mag() - lRep);
          Fs.set( dist.normalize( null).mult( fs));
          p.addExternalForce( Fs);
          p.setVel( PVector.mult( p.getVel(), 0.9));
          if( !p._madeWave){
            map.addWave( new WaveRadial(14, p.getPos(), 6 * (30 + 1.5), 6 * (30 + 1.5)/ (1+1.5)));//amplitude,direction,wavelength,speed
            p._madeWave = true;
          }
        }
      }
    }
  }
}

void addParticle(){
  PVector pos = new PVector( 0, -100, 0);
  PVector vel = new PVector( 0, 0, 0);
  Particle p = new Particle( pos, vel, 10, 50, true);
  particles.add( p);
}

void draw()
{
  background(255);
  lights();
  map.update();
  current_time = millis()/1000f;
  updateWaterParticles();
  updateParticles( (current_time-prev_time)/100);
  computeCollisions();
  if(_viewmode) map.presentWired();
  else map.present();
  for( Particle p : particles){
    p.display();
  }
  // for( int i = 0; i < _MAP_SIZE; i++){
  //   for( int j = 0; j < _MAP_SIZE; j++){
  //     waterParticles[i][j].display();
  //   }
  // }
  presentAxis();
  drawInteractiveInfo();
  if(_clear)
  {
    map.waves.clear();
    map.waveArray = new Wave[0];
    _clear = false;
  }
}

void drawInteractiveInfo()
{
  float textSize = 100;
  float offsetX = -500;
  float offsetZ = -1000;
  float offsetY = -1000;
  
  int i = 0;
  noStroke();
  textSize(textSize);
  fill(0xff000000);
  text("q : sinusoidal wave", offsetX, offsetY + textSize*(++i),offsetZ);
  text("w : radial wave", offsetX, offsetY + textSize*(++i),offsetZ);
  text("e : gerstner wave", offsetX, offsetY + textSize*(++i),offsetZ);
  text("r : change viewmode", offsetX, offsetY + textSize*(++i),offsetZ);
  text("t : reset", offsetX, offsetY + textSize*(++i),offsetZ);
}

void keyPressed()
{
  float amplitude = random(2f)+8f;
  float dx = random(2f)-1;
  float dz = random(2f)-1;
  float wavelength = amplitude * (30 + random(2f));
  float speed = wavelength / (1+random(3f));
  
  if(key == 'q')
  {
    map.addWave(new WaveDirectional(amplitude,new PVector(dx,0,dz),wavelength,speed));//amplitude,direction,wavelength,speed
  }
  if(key == 'w')
  {
    map.addWave(new WaveRadial(amplitude,new PVector(dx*(_MAP_SIZE*_MAP_CELL_SIZE/2f),0,dz*(_MAP_SIZE*_MAP_CELL_SIZE/2f)),wavelength,speed));//amplitude,direction,wavelength,speed
  }
  if(key == 'e')
  {
    map.addWave(new WaveGerstner(amplitude,new PVector(dx,0,dz),wavelength,speed));//amplitude,direction,wavelength,speed
  }
  if(key == 'r')
  {
    _viewmode = !_viewmode;
  }
  if(key == 't')
  {
    _clear = true;
  }
  
  if(key == '1')
  {
    map.waves.get(0).W -=.001;  
  }
  
  if(key == '2')
  {
    map.waves.get(0).W +=.001;  
  }
  
  if(key == '3')
  {
    map.waves.get(0).phi -=.1;  
  }
  
  if(key == '4')
  {
    map.waves.get(0).phi +=.1;  
  }
  
  if(key == '5')
  {
    map.waves.get(0).A -=1;  
  }
  
  if(key == '6')
  {
    map.waves.get(0).A +=1;  
  }

  if( key == 'p' || key == 'P'){
    addParticle();
  }
}

void presentAxis()
{
  float axisSize = _MAP_SIZE*2f;
  stroke(0xffff0000);
  line(0,0,0,axisSize,0,0);
  stroke(0xff00ff00);
  line(0,0,0,0,-axisSize,0);
  stroke(0xff0000ff);
  line(0,0,0,0,0,axisSize);
}
