// Equations
/*
 *  T = 1         // seconds
 *  f = 1/T       // Hz
 *  w = 2*PI*f    // rads/s
 *  R = 1         // meters
 *  dt = 0.01     // seconds
 * 
 *  1 meter = 100 pixels
 * 
 *  x = r * cos( w*t)
 *  y = r * sin( w*t)
 */

// Parameters
float R = 1;      // radius
float T = 1;      // Period
float f = 1/T;    // Frequency
float w = 2*PI*f; // Angular velocity
float dw = 0;
float dt = 0.01;  // Diferencial Time
float time = 0;   // Total Simulated Time

PVector pos = new PVector();
PVector center = new PVector();

void setup(){
  size( 1280, 720);
  center.set( width/2, height/2);
}

void draw(){

  step();

  drawStaticEnvironment();
  drawDinamicEnvironment();

  time += dt;
}

void drawStaticEnvironment(){
  background( #fafafa);

  fill( #d83a3a);
  circle( center.x, center.y, 20);

  fill( #000000);
  textSize( 18);
  textAlign( RIGHT);
  text( "Simulated Time: " + time, width, 1*width/30);
}

void drawDinamicEnvironment(){
  fill( #47e047);
  circle( pos.x, pos.y, 20);
}

void step(){

  dw += 2*PI*f;

  pos.set( center.x + R*100 * cos( dw*dt), center.y + R*100 * sin( dw*dt)); 
  println( "pos: ", pos);
}

